@echo off
setlocal enabledelayedexpansion

echo --------------------------------------------------------
echo Deactivating Clara E Software Component
devcon disable "SWC\VEN_1382&GUID_{5D72A5A1-1EA7-4fe4-993B-C9FB5A4B34FB}"
devcon remove "SWC\VEN_1382&GUID_{5D72A5A1-1EA7-4fe4-993B-C9FB5A4B34FB}"

echo --------------------------------------------------------
echo Deactivating Clara E Hardware Device
devcon disable "PCI\VEN_1382&DEV_9050"
devcon remove "PCI\VEN_1382&DEV_9050"

echo --------------------------------------------------------
echo Stop Clara E Service
sc stop "mabasesvc"

echo --------------------------------------------------------
echo Delete Clara E Service
sc delete "mabasesvc"

pushd %systemroot%\inf

echo --------------------------------------------------------
echo searching for MARIAN Clara E Software Component Drivers
set "madrvinf_str=SWC\VEN_1382&GUID_{5D72A5A1-1EA7-4fe4-993B-C9FB5A4B34FB}"
call :remove

echo(
echo --------------------------------------------------------
echo searching for MARIAN Clara E Driver Extensions
set "madrvinf_str=masw_amd64,PCI\VEN_1382&DEV_9050"
call :remove

echo(
echo --------------------------------------------------------
echo searching for MARIAN Clara E Base Drivers
set "madrvinf_str=mapci_amd64,PCI\VEN_1382&DEV_9050"
call :remove

goto :end


:remove
for %%F in (oem*.inf) do (
    findstr /I /C:"%madrvinf_str%" "%%F" >nul
    if !errorlevel! == 0 (
		echo(
        echo Found: %%F
		echo removing %%F ...
		pnputil /delete-driver %%F /uninstall /force
		if not !errorlevel! == 0 (
		  echo Allowed to fail.
		)
    ) else (
        <nul set /p=.
    )
)
goto :eof

:end
popd

echo(
echo PLEASE RESTART YOUR COMPUTER!
pause





