# Steps to setup MARIAN Clara E drivers at LiveBox
Because in older versions of Windows the Device Manager does not update Software Component Drivers simultaneously with the Base Hardware driver,
and MARIAN's "setup.exe" does not work with such older Windows versions, Software Component Drivers and Base Hardware Drivers must be updated manually in sync. You can do this like described in "Driver Update" or, after several unlucky driver update attempts it may be a good idea to go ahead directly with "Remove all older versions".

## Driver Update
1. Update Clara E in "Sound, video and game controllers" by clicking it right, then choose "Update Driver"
2. Choose the folder of the v4.7.1.0 drivers files and update.
3. Ignore/skip any messages about incompatible firmware.
4. Immediantely afterwards Update Clara E in "Software Components" by clicking it right, then choose "Update Driver"
5. Choose the folder of the v4.7.1.0 drivers files and update.
6. Ignore/skip any messages about incompatible firmware!
7. Restart your computer.

## Check Driver Update Results
* Clara E Icon should appear as taskbar icon. 
	Check Version via Taskbar Icon | Click | About. Should be 4.7.1.0.
	
	OR
	
* You get a firmware update request message from Clara E GUI 
	Testwise click "No" - then check Version via Taskbar Icon Menu | About. Should be 4.7.1.0. 
	If OK, open Settings | Firmware via Taskbar Icon Menu, "Start Dante Firmware Update Manager now" and proceed.

If the first or the second topic does NOT happen, continue with "Remove all older versions".

## Remove all older versions
1. Extract "rmce.zip" to any folder
2. Open command line (cmd.exe) with administrator priviledges
3. Change current path to the folder where you extracted "rmce.zip"
4. Execute "rmce.bat"
5. Restart your system

### Check Removal Results
1. You should NOT get any firmware update request messages from Clara E GUI - OK.
2. Clara E Icon should NOT appear as taskbar icon - OK.
3. NO "Clara E" in windows device manager in "Sound, video and game controllers" - OK.
4. NO "Clara E" in windows device manager in "Software Components" - OK.

If all topics are OK, continue with "Install new driver"
Else, execute the steps in "More Cleanup required", which is also a good idea if you want to have everything really clean.

### More Cleanup required
1. Open Windows Device Manager. Enable "View | Show hidden devices"
2. **First**: Uninstall all Clara E in "Software Components" (Right click | "Uninstall device")
3. **Second**: Uninstall all Clara E in "Sound, video and game controllers" (Right click | "Uninstall device")
3. Enable "Delete the driver software ... " if this option is avaiable during uninstall.
4. Restart your system
5. Again - "Check Removal Results"

## Install new driver
If all older driver software is removed:
1. Open Windows Device Manager
2. "Other Devices" | "Multimedia Controller", right click, "Update Driver"

### Check Install Results
1. Within some seconds ... :
* Clara E Icon should appear as taskbar icon. 
	Check Version via Taskbar Icon | Click | About. Should be 4.7.1.0.
	
	OR
	
* You should get a firmware update request message from Clara E GUI 
	Testwise click "No" - then check Version via Taskbar Icon Menu | About. Should be 4.7.1.0. 
	If OK, via Taskbar Icon Menu open Settings | Firmware and "Start Dante Firmware Update Manager now"

If neither topic 1 nor topic 2 takes place, restart your computer and check the install results again.
After that restart, if the results are still not OK, execute the steps in "More Cleanup required"
	
---
MARIAN GmbH 11.07.2025
